/*
 * Decompiled with CFR 0.152.
 */
package jace.apple2e;

import jace.apple2e.MOS65C02;
import jace.apple2e.RAM128k;
import jace.apple2e.SoftSwitches;
import jace.apple2e.Speaker;
import jace.apple2e.VideoDHGR;
import jace.config.Configurable;
import jace.config.Reconfigurable;
import jace.core.Card;
import jace.core.Computer;
import jace.core.Motherboard;
import jace.core.RAM;
import jace.hardware.CardDiskII;
import jace.hardware.CardSSC;
import jace.hardware.massStorage.CardMassStorage;

public class Apple2e
extends Computer
implements Reconfigurable {
    static int IRQ_VECTOR = 1010;
    Motherboard motherboard;
    @Configurable(name="Slot 1")
    private Card card1 = null;
    @Configurable(name="Slot 2")
    private Card card2 = new CardSSC();
    @Configurable(name="Slot 3")
    private Card card3 = null;
    @Configurable(name="Slot 4")
    private Card card4 = null;
    @Configurable(name="Slot 5")
    private Card card5 = null;
    @Configurable(name="Slot 6")
    private Card card6 = new CardDiskII();
    @Configurable(name="Slot 7")
    private Card card7 = new CardMassStorage();

    public Apple2e() {
        try {
            this.setMemory(new RAM128k());
            this.setCpu(new MOS65C02());
            this.setVideo(new VideoDHGR());
            for (SoftSwitches s : SoftSwitches.values()) {
                s.getSwitch().register();
            }
            Motherboard.miscDevices.add(new Speaker());
            this.loadRom("jace/data/apple2e.rom");
            this.reconfigure();
        }
        catch (Throwable t) {
            System.err.println("Unable to initalize virtual machine");
            t.printStackTrace(System.err);
        }
    }

    public void coldStart() {
        this.reboot();
        for (SoftSwitches s : SoftSwitches.values()) {
            s.getSwitch().reset();
        }
        this.motherboard = new Motherboard();
        this.motherboard.go();
    }

    public void reboot() {
        RAM r = this.getMemory();
        r.write(IRQ_VECTOR, (byte)0, false);
        r.write(IRQ_VECTOR + 1, (byte)0, false);
        r.write(IRQ_VECTOR + 2, (byte)0, false);
        this.warmStart();
    }

    public void warmStart() {
        this.getCpu().setHalt(true);
        for (SoftSwitches softSwitches : SoftSwitches.values()) {
            softSwitches.getSwitch().reset();
        }
        this.getMemory().configureActiveMemory();
        this.getVideo().configureVideoMode();
        this.getCpu().reset();
        for (Card card : this.getMemory().getAllCards()) {
            if (card == null) continue;
            card.reset();
        }
    }

    public void notifyVBLStateChanged(boolean state) {
    }

    public void reconfigure() {
        if (this.card1 != null) {
            this.getMemory().addCard(this.card1, 1);
        }
        if (this.card2 != null) {
            this.getMemory().addCard(this.card2, 2);
        }
        if (this.card3 != null) {
            this.getMemory().addCard(this.card3, 3);
        }
        if (this.card4 != null) {
            this.getMemory().addCard(this.card4, 4);
        }
        if (this.card5 != null) {
            this.getMemory().addCard(this.card5, 5);
        }
        if (this.card6 != null) {
            this.getMemory().addCard(this.card6, 6);
        }
        if (this.card7 != null) {
            this.getMemory().addCard(this.card7, 7);
        }
    }
}

